<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Imports\MarksEntryImport;
use App\Http\Requests\MarksEntryRequest;
use Maatwebsite\Excel\Facades\Excel;

class MarksEntryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $class = DB::connection('mysql_second')->table('add_class')->get();
        // return $class;
        return view('admin.marks_entry.index', compact('class'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(MarksEntryRequest $request)
    {
        try {
            DB::connection('mysql_second')->beginTransaction();

            $exportData = [
                'class_id'=> $request->class_id,
                'exam_id'=> $request->exam_id,
                'group_id' => $request->group_id,
                'subject_id' => $request->subject_id,
                'subject_part_id' => $request->subject_part_id,
            ];

            Excel::import(new MarksEntryImport($exportData), $request->file('excel'));

            DB::connection('mysql_second')->commit();

            return response()->json([
                'success' => true,
                'message' => 'Marks Entry Data Inserted Successfully'
            ], 200);

        } catch (\Exception $e) {
            DB::connection('mysql_second')->rollBack();

            return response()->json([
                'success' => false,
                'message' => 'Failed to insert marks entry data',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function getExamType(Request $request)
    {
        $exam_type = DB::connection('mysql_second')->table('exam_type_info')
            ->where('select_class', $request->class_id)
            ->get();

        $output = '<option value="">Select One</option>';
        foreach ($exam_type as $row) {
            $output .= '<option value="' . $row->exam_id . '">' . $row->exam_type . '</option>';
        }

        return $output;
    }

    public function getGroup(Request $request)
    {
        $group = DB::connection('mysql_second')->table('add_group')
            ->where('class_id', $request->class_id)
            ->get();

        $output = '<option value="">Select One</option>';
        foreach ($group as $row) {
            $output.= '<option value="'. $row->id. '">'. $row->group_name. '</option>';
        }

        return $output;
    }

    public function getSubject(Request $request)
    {
        $subject = DB::connection('mysql_second')->table('add_subject_info')
            ->where('class_id', $request->class_id)
            ->where('group_id', $request->group_id)
            ->where('select_subject_type', $request->subject_type)
            ->get();

        $output = '<option value="">Select One</option>';
        foreach ($subject as $row) {
            $output.= '<option value="'. $row->id. '">'. $row->subject_name. '</option>';
        }

        return $output;
    }

    public function getSubjectPart(Request $request)
    {
        $subject_part = DB::connection('mysql_second')->table('add_subject_part_info')
            ->where('subject_name', $request->subject_id)
            ->where('class_id', $request->class_id)
            ->where('group_id', $request->group_id)
            ->where('exam_type', $request->exam_id)
            ->get();
        $output = '<option value="">Select One</option>';
        foreach ($subject_part as $row) {
            $output.= '<option value="'. $row->part_id. '">'. $row->subject_part_name. '</option>';
        }

        return $output;
    }
}
